<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bureau of Cybercrime Intelligence </title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white">
                    <i class="bi bi-list"></i>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom active" href="index">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="contact">Contact</a>
                    </li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section (with index.php background but indexxx.php content) -->
    <section class="hero-section">
        <div class="hero-overlay"></div>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <div class="hero-badge">
                        <i class="bi bi-shield-check"></i>
                        <span>EST. 2020 | CYBERCRIME INTELLIGENCE</span>
                    </div>
                    <h1 class="hero-title">Defending Digital Intelligence</h1>
                    <p class="hero-subtitle">Elite cybercrime investigation and threat intelligence services protecting organizations from evolving digital threats</p>
                    
                    <div class="hero-stats">
                        <div class="stat-item-hero">
                            <h3>5000+</h3>
                            <p>Cases Resolved</p>
                        </div>
                        <div class="stat-item-hero">
                            <h3>98%</h3>
                            <p>Success Rate</p>
                        </div>
                        <div class="stat-item-hero">
                            <h3>24/7</h3>
                            <p>Response Time</p>
                        </div>
                    </div>

                    <div class="hero-actions">
                        <a href="report-cybercrime" class="btn btn-hero-primary">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Incident
                        </a>
                        <a href="services" class="btn btn-hero-secondary">
                            <i class="bi bi-info-circle me-2"></i> Our Services
                        </a>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="hero-card">
                        <div class="hero-card-header">
                            <i class="bi bi-clock-fill"></i>
                            <h4>24/7 Emergency Response</h4>
                        </div>
                        <div class="hero-card-body">
                            <p>Immediate assistance for active cyber attacks</p>
                            <div class="emergency-contact-box">
                                <div class="contact-method">
                                    <i class="bi bi-telephone-fill"></i>
                                    <div>
                                        <small>Emergency Hotline</small>
                                        <strong>+231 (90) 909 4712</strong>
                                    </div>
                                </div>
                                <div class="contact-method">
                                    <i class="bi bi-envelope-fill"></i>
                                    <div>
                                        <small>Email Response</small>
                                        <strong>emergency@bci.com</strong>
                                    </div>
                                </div>
                            </div>
                            <div class="response-time">
                                <i class="bi bi-lightning-charge-fill"></i>
                                <span>Average Response Time: <strong>15 minutes</strong></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Quick Access Section -->
    <section class="quick-access-section">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-3">
                    <a href="report-cybercrime" class="quick-access-card">
                        <i class="bi bi-exclamation-triangle-fill"></i>
                        <h5>Report Crime</h5>
                        <p>Submit incident report</p>
                        <span class="quick-link">Go <i class="bi bi-arrow-right"></i></span>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="cyber-threats" class="quick-access-card">
                        <i class="bi bi-shield-exclamation"></i>
                        <h5>Threat Intel</h5>
                        <p>Current threat analysis</p>
                        <span class="quick-link">Go <i class="bi bi-arrow-right"></i></span>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="services" class="quick-access-card">
                        <i class="bi bi-gear-fill"></i>
                        <h5>Our Services</h5>
                        <p>Forensics & response</p>
                        <span class="quick-link">Go <i class="bi bi-arrow-right"></i></span>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="contact" class="quick-access-card">
                        <i class="bi bi-headset"></i>
                        <h5>Contact Us</h5>
                        <p>Get in touch</p>
                        <span class="quick-link">Go <i class="bi bi-arrow-right"></i></span>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Mission Statement -->
    <section class="mission-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center">
                    <div class="mission-badge">MISSION STATEMENT</div>
                    <h2 class="section-title-main">Protecting Digital Assets Through Elite Intelligence</h2>
                    <p class="lead-text">The Bureau of Cybercrime Intelligence (BCI) is a specialized investigative agency dedicated to combating sophisticated cyber threats. We provide world-class digital forensics, incident response, and threat intelligence services to organizations worldwide.</p>
                </div>
            </div>
            <div class="row g-4 mt-4">
                <div class="col-md-4">
                    <div class="mission-card">
                        <div class="mission-icon">
                            <i class="bi bi-bullseye"></i>
                        </div>
                        <h4>Our Mission</h4>
                        <p>To investigate, prevent, and respond to cybercrime through advanced intelligence gathering and forensic analysis</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mission-card">
                        <div class="mission-icon">
                            <i class="bi bi-eye-fill"></i>
                        </div>
                        <h4>Our Vision</h4>
                        <p>A safer digital world where organizations can operate securely, confident in their defenses</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mission-card">
                        <div class="mission-icon">
                            <i class="bi bi-award-fill"></i>
                        </div>
                        <h4>Our Values</h4>
                        <p>Integrity, excellence, innovation, and collaboration in every investigation</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Core Services Section -->
    <section class="services-showcase">
        <div class="container">
            <div class="text-center mb-5">
                <div class="section-badge">CORE CAPABILITIES</div>
                <h2 class="section-title-main  text-white">Professional Services</h2>
                <p class="section-subtitle">Comprehensive cybercrime solutions backed by decades of combined expertise</p>
            </div>
            
            <div class="row g-4">
                <!-- Incident Response -->
                <div class="col-lg-4 col-md-6">
                    <div class="service-showcase-card">
                        <div class="service-number">01</div>
                        <div class="service-icon-large">
                            <i class="bi bi-lightning-charge-fill"></i>
                        </div>
                        <h3>Incident Response</h3>
                        <p>Rapid containment and eradication of active cyber attacks with 24/7 emergency response capabilities</p>
                        <ul class="service-highlights">
                            <li>Containment within 2 hours</li>
                            <li>Complete forensic analysis</li>
                            <li>Recovery roadmap</li>
                            <li>Executive reporting</li>
                        </ul>
                        <a href="services" class="service-link">Learn More <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>

                <!-- Digital Forensics -->
                <div class="col-lg-4 col-md-6">
                    <div class="service-showcase-card">
                        <div class="service-number">02</div>
                        <div class="service-icon-large">
                            <i class="bi bi-search"></i>
                        </div>
                        <h3>Digital Forensics</h3>
                        <p>Court-admissible evidence collection and analysis across all digital platforms and devices</p>
                        <ul class="service-highlights">
                            <li>Chain of custody protocols</li>
                            <li>Expert witness testimony</li>
                            <li>Multi-platform analysis</li>
                            <li>Detailed reporting</li>
                        </ul>
                        <a href="services" class="service-link">Learn More <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>

                <!-- Threat Intelligence -->
                <div class="col-lg-4 col-md-6">
                    <div class="service-showcase-card">
                        <div class="service-number">03</div>
                        <div class="service-icon-large">
                            <i class="bi bi-cpu-fill"></i>
                        </div>
                        <h3>Threat Intelligence</h3>
                        <p>Actionable intelligence on threat actors, malware, and attack patterns to strengthen defenses</p>
                        <ul class="service-highlights">
                            <li>Real-time threat feeds</li>
                            <li>Actor profiling</li>
                            <li>Custom detection rules</li>
                            <li>Dark web monitoring</li>
                        </ul>
                        <a href="services" class="service-link">Learn More <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>
            </div>

            <div class="text-center mt-5">
                <a href="services" class="btn btn-primary-large">
                    View All Services <i class="bi bi-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Threats We Combat -->
    <section class="threats-overview">
        <div class="container">
            <div class="text-center mb-5">
                <div class="section-badge badge-danger">THREAT LANDSCAPE</div>
                <h2 class="section-title-main">Threats We Combat</h2>
                <p class="section-subtitle">Protecting against the full spectrum of cybercrime</p>
            </div>

            <div class="row g-3">
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-envelope-exclamation-fill"></i>
                        <h6>Phishing</h6>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-bug-fill"></i>
                        <h6>Ransomware</h6>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-database-fill"></i>
                        <h6>Data Breach</h6>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-credit-card-fill"></i>
                        <h6>Fraud</h6>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-person-badge-fill"></i>
                        <h6>Account Takeover</h6>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6">
                    <div class="threat-badge-card">
                        <i class="bi bi-shield-fill-exclamation"></i>
                        <h6>DDoS</h6>
                    </div>
                </div>
            </div>

            <div class="text-center mt-5">
                <a href="cyber-threats" class="btn btn-outline-danger-large">
                    Threat Intelligence Center <i class="bi bi-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Why Choose BCI -->
    <section class="why-choose-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="section-badge">WHY BCI</div>
                    <h2 class="section-title-main">Trusted By Organizations Worldwide</h2>
                    <p class="lead-text">BCI combines cutting-edge technology with decades of investigative experience to deliver unmatched cybercrime intelligence services.</p>
                    
                    <div class="feature-list">
                        <div class="feature-item-modern">
                            <div class="feature-icon">
                                <i class="bi bi-shield-check"></i>
                            </div>
                            <div>
                                <h5>Elite Expertise</h5>
                                <p>Team of certified professionals with law enforcement and military backgrounds</p>
                            </div>
                        </div>
                        <div class="feature-item-modern">
                            <div class="feature-icon">
                                <i class="bi bi-clock-history"></i>
                            </div>
                            <div>
                                <h5>Rapid Response</h5>
                                <p>24/7 emergency response with average 15-minute initial contact time</p>
                            </div>
                        </div>
                        <div class="feature-item-modern">
                            <div class="feature-icon">
                                <i class="bi bi-graph-up-arrow"></i>
                            </div>
                            <div>
                                <h5>Proven Results</h5>
                                <p>98% success rate in incident resolution and threat neutralization</p>
                            </div>
                        </div>
                        <div class="feature-item-modern">
                            <div class="feature-icon">
                                <i class="bi bi-lock-fill"></i>
                            </div>
                            <div>
                                <h5>Confidentiality</h5>
                                <p>Strict data protection and confidentiality protocols for all engagements</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="why-choose-visual">
                        <div class="certification-badge">
                            <i class="bi bi-patch-check-fill"></i>
                            <div>
                                <strong>ISO 27001</strong>
                                <p>Certified</p>
                            </div>
                        </div>
                        <div class="certification-badge">
                            <i class="bi bi-shield-fill-check"></i>
                            <div>
                                <strong>SOC 2</strong>
                                <p>Compliant</p>
                            </div>
                        </div>
                        <div class="certification-badge">
                            <i class="bi bi-award-fill"></i>
                            <div>
                                <strong>Industry Leader</strong>
                                <p>2020-2026</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section (index.php background with indexxx.php content) -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title">Under Cyber Attack?</h2>
            <p class="cta-subtitle" style="opacity: 1; color: white;">Our emergency response team is available 24/7 to contain threats and protect your organization</p>
            <div class="cta-actions-modern">
                <a href="report-cybercrime" class="btn btn-cta-danger">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                </a>
                <a href="contact" class="btn btn-cta-outline">
                    <i class="bi bi-telephone-fill me-2"></i> Call +231 (90) 909 4712
                </a>
            </div>
            <div class="cta-assurance">
                <i class="bi bi-shield-lock-fill"></i>
                <span>All communications encrypted & confidential</span>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Animated counters for stats
        const animateCounter = (element) => {
            const target = parseInt(element.getAttribute('data-target'));
            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.floor(current);
                }
            }, 16);
        };

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'index.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'index') ||
                    (currentPage === 'index.php' && linkPage === 'index')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
</body>
</html>
