<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white"><i class="bi bi-list"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="services">Services</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="about">About</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="contact">Contact</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <section class="page-hero">
        <div class="container text-center">
            <h1>Privacy Policy</h1>
            <p>Protecting your data with the highest standards of confidentiality</p>
            <p class="small">Effective Date: October 9, 2025</p>
        </div>
    </section>

    <section class="legal-content-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="legal-card">
                        <div class="legal-toc">
                            <h5>Table of Contents</h5>
                            <ul>
                                <li><a href="#section1">Introduction</a></li>
                                <li><a href="#section2">Who We Are</a></li>
                                <li><a href="#section3">Information We Collect</a></li>
                                <li><a href="#section4">How We Use Your Information</a></li>
                                <li><a href="#section5">Legal Basis for Processing</a></li>
                                <li><a href="#section6">Confidentiality & Evidence Handling</a></li>
                                <li><a href="#section7">Data Retention</a></li>
                                <li><a href="#section8">Data Sharing & Disclosure</a></li>
                                <li><a href="#section9">Data Security</a></li>
                                <li><a href="#section10">Your Rights</a></li>
                                <li><a href="#section11">International Data Transfers</a></li>
                                <li><a href="#section12">Updates to This Policy</a></li>
                                <li><a href="#section13">Contact Information</a></li>
                            </ul>
                        </div>

                        <div class="legal-intro">
                            <p>The Bureau of Cyber Intelligence (BCI) is committed to protecting the privacy and confidentiality of all individuals and organizations that interact with us. This Privacy Policy explains how we collect, use, store, disclose, and safeguard personal and sensitive data in the course of providing cybersecurity, digital forensics, investigative, advisory, and related services.</p>
                            <p>By accessing our website or submitting information to BCI, you acknowledge that you have read and understood this Policy and consent to its terms.</p>
                        </div>

                        <div class="legal-section" id="section1">
                            <h3>1. Introduction</h3>
                            <p>The Bureau of Cyber Intelligence (BCI) is committed to protecting the privacy and confidentiality of all individuals and organizations that interact with us. This Privacy Policy explains how we collect, use, store, disclose, and safeguard personal and sensitive data in the course of providing cybersecurity, digital forensics, investigative, advisory, and related services.</p>
                            <p>By accessing our website or submitting information to BCI, you acknowledge that you have read and understood this Policy and consent to its terms.</p>
                        </div>

                        <div class="legal-section" id="section2">
                            <h3>2. Who We Are</h3>
                            <p>BCI is a multidisciplinary cybersecurity and digital intelligence organization specializing in:</p>
                            <ul>
                                <li>Digital and multimedia forensics</li>
                                <li>Cyber incident response and threat intelligence</li>
                                <li>Legal and advisory services</li>
                                <li>Privacy, compliance, and data protection consulting</li>
                                <li>Private investigations and data recovery</li>
                                <li>Training and awareness programs</li>
                            </ul>
                            <p>We operate with full adherence to data protection, privacy, and cybercrime laws applicable within our jurisdiction and internationally recognized standards.</p>
                        </div>

                        <div class="legal-section" id="section3">
                            <h3>3. Information We Collect</h3>
                            <p>Depending on your interaction with us, BCI may collect:</p>
                            
                            <h4>a. Personal Information</h4>
                            <ul>
                                <li>Full name, contact details, organization, and professional information</li>
                                <li>Identity details (when verifying agents or investigators)</li>
                                <li>Account credentials (if you create a user account on our platform)</li>
                            </ul>

                            <h4>b. Incident & Investigation Data</h4>
                            <ul>
                                <li>Case details, evidence files, and metadata voluntarily provided for analysis or investigation</li>
                                <li>Device identifiers, IP addresses, and system logs (when relevant to a reported incident)</li>
                            </ul>

                            <h4>c. Technical Information</h4>
                            <ul>
                                <li>Website usage data (cookies, analytics, IP logs) for security monitoring and service optimization</li>
                            </ul>

                            <p><strong>We only collect data necessary for legitimate business, investigative, or compliance purposes.</strong></p>
                        </div>

                        <div class="legal-section" id="section4">
                            <h3>4. How We Use Your Information</h3>
                            <p>We use collected information for the following purposes:</p>
                            <ul>
                                <li>To process and investigate cybersecurity incidents or forensic cases</li>
                                <li>To authenticate submissions and verify agents</li>
                                <li>To provide advisory, recovery, and threat intelligence services</li>
                                <li>To comply with legal and regulatory requirements</li>
                                <li>To improve our website, systems, and user experience</li>
                                <li>To train and educate users during capacity-building programs</li>
                            </ul>
                            <p>All information is handled with strict confidentiality and used only for the specific purpose for which it was collected.</p>
                        </div>

                        <div class="legal-section" id="section5">
                            <h3>5. Legal Basis for Processing</h3>
                            <p>BCI processes personal data based on one or more of the following legal bases:</p>
                            <ul>
                                <li><strong>Consent</strong> – where you have given explicit permission</li>
                                <li><strong>Legal Obligation</strong> – where processing is required by law or regulatory mandate</li>
                                <li><strong>Legitimate Interest</strong> – to ensure the security, integrity, and functionality of BCI systems and services</li>
                                <li><strong>Contractual Necessity</strong> – where processing is needed to fulfill our obligations under an agreement</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section6">
                            <h3>6. Confidentiality & Evidence Handling</h3>
                            <p>All evidence and investigation data submitted to BCI is treated with the highest level of confidentiality.</p>
                            <ul>
                                <li>Evidence is accessed only by authorized personnel directly involved in the case</li>
                                <li>Chain-of-custody procedures and audit trails are strictly maintained</li>
                                <li>Data is encrypted both in transit and at rest</li>
                                <li>Access is role-based and reviewed periodically</li>
                            </ul>
                            <p><strong>We never disclose or share investigative materials unless legally required or authorized by the data owner.</strong></p>
                        </div>

                        <div class="legal-section" id="section7">
                            <h3>7. Data Retention</h3>
                            <p>BCI retains personal and case-related data only for as long as necessary to:</p>
                            <ul>
                                <li>Complete the purpose for which it was collected</li>
                                <li>Comply with legal and regulatory obligations</li>
                                <li>Preserve the integrity of ongoing investigations</li>
                            </ul>
                            <p>Once retention periods expire, data is securely deleted or anonymized following approved data destruction protocols.</p>
                        </div>

                        <div class="legal-section" id="section8">
                            <h3>8. Data Sharing & Disclosure</h3>
                            <p><strong>We do not sell or commercialize personal data.</strong></p>
                            <p>Data may only be shared:</p>
                            <ul>
                                <li>With authorized legal or law enforcement bodies (upon lawful request)</li>
                                <li>With trusted service providers under confidentiality agreements</li>
                                <li>With your explicit consent when required for collaboration or resolution of a case</li>
                            </ul>
                            <p>All third-party partners are required to comply with the same privacy and security standards upheld by BCI.</p>
                        </div>

                        <div class="legal-section" id="section9">
                            <h3>9. Data Security</h3>
                            <p>BCI employs robust technical and organizational measures to protect data, including:</p>
                            <ul>
                                <li>Encryption, firewalls, and intrusion detection systems</li>
                                <li>Multi-factor authentication and access control mechanisms</li>
                                <li>Secure storage facilities and isolated forensic environments</li>
                                <li>Regular security audits and vulnerability assessments</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section10">
                            <h3>10. Your Rights</h3>
                            <p>Depending on applicable law, you may have the right to:</p>
                            <ul>
                                <li>Access, correct, or delete your personal data</li>
                                <li>Withdraw consent at any time (where applicable)</li>
                                <li>Request information on how your data is being processed</li>
                                <li>Lodge a complaint with a relevant data protection authority</li>
                            </ul>
                            <p>Requests can be submitted via <a href="mailto:privacy@bci.gov">privacy@bci.gov</a></p>
                        </div>

                        <div class="legal-section" id="section11">
                            <h3>11. International Data Transfers</h3>
                            <p>If your data is transferred across borders for analysis or collaboration, BCI ensures that appropriate safeguards and data transfer agreements are in place to protect your information in accordance with privacy laws.</p>
                        </div>

                        <div class="legal-section" id="section12">
                            <h3>12. Updates to This Policy</h3>
                            <p>BCI may update this Privacy Policy periodically to reflect legal, operational, or technological changes. Updated versions will be posted on our website with the effective date clearly indicated.</p>
                        </div>

                        <div class="legal-section" id="section13">
                            <h3>13. Contact Information</h3>
                            <p>For questions or privacy-related concerns, please contact:</p>
                            <div class="contact-box">
                                <p><strong>Bureau of Cyber Intelligence (BCI)</strong><br>
                                Privacy & Compliance Office</p>
                                <p><strong>Email:</strong> <a href="mailto:privacy@bci.gov">privacy@bci.gov</a><br>
                                <strong>Web:</strong> www.bci.gov</p>
                                <p class="text-muted mt-3" style="font-size: 0.9rem;">Bureau of Cyber Intelligence — Defending Trust. Securing the Future.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

     <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-4 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="report-cybercrime"><i class="bi bi-exclamation-triangle me-2"></i> Report Cybercrime</a></li>
                        <li><a href="privacy-policy"><i class="bi bi-file-text me-2"></i> Privacy Policy</a></li>
                        <li><a href="terms-of-service"><i class="bi bi-file-text me-2"></i> Terms of Service</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-4 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Privacy Department</h6>
                                <p class="mb-0 text-light"><a href="mailto:privacy@bci.gov" style="color: inherit; text-decoration: none;">privacy@bci.gov</a></p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Phone</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/main.js"></script>
</body>
</html>