<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report Cybercrime - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
     <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white">
                    <i class="bi bi-list"></i>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="index">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="contact">Contact</a>
                    </li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="page-hero-emergency">
        <div class="container text-center">
            <div class="emergency-badge">
                <i class="bi bi-exclamation-triangle-fill"></i>
            </div>
            <h1>Report Cyber Incident</h1>
            <p>Immediate response for active cyber attacks and security breaches</p>
            <div class="emergency-hotline">
                <i class="bi bi-telephone-fill"></i>
                <span>24/7 Emergency Hotline: +231 (90) 909 4712</span>
            </div>
        </div>
    </section>

    <!-- Report Form Section -->
    <section class="report-form-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <!-- Report Form -->
                    <div class="report-form-card">
                        <div class="form-header">
                            <i class="bi bi-file-earmark-lock-fill"></i>
                            <h2>Secure Incident Report Form</h2>
                            <p class="text-muted">All information is encrypted and handled according to strict confidentiality protocols</p>
                        </div>

                        <!-- Alert Messages Container -->
                        <div id="alertsContainer"></div>

                        <form id="reportForm" class="needs-validation" novalidate enctype="multipart/form-data">
                            <input type="hidden" id="priorityLevel" name="priority" value="">
                            
                            <!-- Priority Selection -->
                            <div class="priority-selector mb-5">
                                <h3 class="text-center mb-4">Select Incident Priority</h3>
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <div class="priority-card critical" onclick="selectPriority('critical')">
                                            <i class="bi bi-exclamation-triangle-fill"></i>
                                            <h4>Critical</h4>
                                            <p>Active attack, data breach in progress, ransomware encryption</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="priority-card high" onclick="selectPriority('high')">
                                            <i class="bi bi-shield-exclamation"></i>
                                            <h4>High</h4>
                                            <p>Recent breach, suspicious activity, unauthorized access detected</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="priority-card medium" onclick="selectPriority('standard')">
                                            <i class="bi bi-info-circle-fill"></i>
                                            <h4>Standard</h4>
                                            <p>General inquiry, phishing attempt, security concern</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Reporter Information -->
                            <div class="form-section">
                                <h4><i class="bi bi-person-fill me-2"></i>Reporter Information</h4>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                        <input type="text" name="fullName" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Organization/Company <span class="text-danger">*</span></label>
                                        <input type="text" name="organization" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                                        <input type="tel" name="phone" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Position/Title</label>
                                        <input type="text" name="position" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Preferred Contact Method</label>
                                        <select name="contactMethod" class="form-select">
                                            <option>Email</option>
                                            <option>Phone</option>
                                            <option>Secure Messaging</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Incident Details -->
                            <div class="form-section">
                                <h4><i class="bi bi-shield-exclamation me-2"></i>Incident Details</h4>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Incident Type <span class="text-danger">*</span></label>
                                        <select name="incidentType" class="form-select" required>
                                            <option value="">Select incident type</option>
                                            <option>Ransomware Attack</option>
                                            <option>Data Breach</option>
                                            <option>Phishing Attack</option>
                                            <option>Malware Infection</option>
                                            <option>DDoS Attack</option>
                                            <option>Account Takeover</option>
                                            <option>Payment Fraud</option>
                                            <option>Insider Threat</option>
                                            <option>Other</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">When Did This Occur? <span class="text-danger">*</span></label>
                                        <input type="datetime-local" name="incidentDate" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Current Status</label>
                                        <select name="incidentStatus" class="form-select">
                                            <option>Attack In Progress</option>
                                            <option>Recently Discovered</option>
                                            <option>Under Investigation</option>
                                            <option>Contained</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Number of Systems Affected</label>
                                        <input type="number" name="affectedSystems" class="form-control" placeholder="Approximate number">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Detailed Description <span class="text-danger">*</span></label>
                                        <textarea name="incidentDescription" class="form-control" rows="5" required placeholder="Provide detailed information about the incident, including what happened, when it was discovered, and any actions taken..."></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- Impact Assessment -->
                            <div class="form-section">
                                <h4><i class="bi bi-graph-down me-2"></i>Impact Assessment</h4>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Data Compromised?</label>
                                        <select name="dataCompromised" class="form-select">
                                            <option value="">Select option</option>
                                            <option value="Unknown">Unknown</option>
                                            <option value="Yes - Customer Data">Yes - Customer Data</option>
                                            <option value="Yes - Employee Data">Yes - Employee Data</option>
                                            <option value="Yes - Financial Data">Yes - Financial Data</option>
                                            <option value="Yes - Intellectual Property">Yes - Intellectual Property</option>
                                            <option value="No">No</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Estimated Financial Impact</label>
                                        <select name="financialImpact" class="form-select">
                                            <option value="">Select option</option>
                                            <option value="Under $10,000">Under $10,000</option>
                                            <option value="$10,000 - $50,000">$10,000 - $50,000</option>
                                            <option value="$50,000 - $250,000">$50,000 - $250,000</option>
                                            <option value="$250,000 - $1M">$250,000 - $1M</option>
                                            <option value="Over $1M">Over $1M</option>
                                            <option value="Unknown">Unknown</option>
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Business Operations Impact</label>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="businessImpact" value="Systems Offline" id="impact1">
                                            <label class="form-check-label" for="impact1">Systems Offline</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="businessImpact" value="Revenue Loss" id="impact2">
                                            <label class="form-check-label" for="impact2">Revenue Loss</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="businessImpact" value="Reputational Damage" id="impact3">
                                            <label class="form-check-label" for="impact3">Reputational Damage</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="businessImpact" value="Regulatory Concerns" id="impact4">
                                            <label class="form-check-label" for="impact4">Regulatory Concerns</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Evidence Upload -->
                            <div class="form-section">
                                <h4><i class="bi bi-file-earmark-arrow-up me-2"></i>Evidence & Attachments</h4>
                                <div class="upload-area">
                                    <i class="bi bi-cloud-upload"></i>
                                    <p>Drag and drop files here or click to browse</p>
                                    <input type="file" name="evidenceFiles" id="fileUpload" class="d-none" multiple>
                                    <button type="button" class="btn btn-outline-primary mt-2" onclick="document.getElementById('fileUpload').click()">
                                        Select Files
                                    </button>
                                    <small class="text-muted d-block mt-2">Accepted: Screenshots, logs, emails, documents (Max 50MB per file)</small>
                                </div>
                            </div>

                            <!-- Law Enforcement -->
                            <div class="form-section">
                                <h4><i class="bi bi-building me-2"></i>Law Enforcement & Notifications</h4>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label">Have you reported this to law enforcement?</label>
                                        <select name="lawEnforcement" class="form-select">
                                            <option>Not Yet</option>
                                            <option>Yes - Local Police</option>
                                            <option>Yes - FBI/National Agency</option>
                                            <option>Yes - Multiple Agencies</option>
                                            <option>Plan to Report</option>
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="consent" id="consent">
                                            <label class="form-check-label" for="consent">
                                                I consent to BCI sharing relevant information with law enforcement agencies if necessary
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Submission -->
                            <div class="form-section">
                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle-fill me-2"></i>
                                    <strong>What happens next?</strong> Our incident response team will review your submission and contact you within 2 hours for critical incidents, 24 hours for others.
                                </div>
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="checkbox" id="terms" required>
                                    <label class="form-check-label" for="terms">
                                        I certify that the information provided is accurate and agree to BCI's <a href="privacy-policy">Privacy Policy</a> and <a href="terms-of-service">Terms of Service</a>
                                    </label>
                                </div>
                                <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                    <button type="submit" class="btn btn-danger btn-lg px-5">
                                        <i class="bi bi-send-fill me-2"></i> Submit Incident Report
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary btn-lg px-5">
                                        <i class="bi bi-telephone-fill me-2"></i> Call Emergency Hotline
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Reporting Guidelines Section -->
    <section class="threats-detail-section">
        <div class="container">
            <h2 class="section-title mb-5">Reporting Guidelines</h2>
            
            <div class="row g-4">
                <!-- Before Reporting -->
                <div class="col-lg-3 col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-icon mb-4">
                            <i class="bi bi-shield-fill"></i>
                        </div>
                        <h4 class="guideline-title mb-3">Before Reporting</h4>
                        <ul class="guideline-list">
                            <li>Do not delete any evidence</li>
                            <li>Preserve system logs and files</li>
                            <li>Take screenshots if safe to do so</li>
                            <li>Isolate affected systems if possible</li>
                        </ul>
                    </div>
                </div>

                <!-- What to Include -->
                <div class="col-lg-3 col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-icon mb-4">
                            <i class="bi bi-building-fill"></i>
                        </div>
                        <h4 class="guideline-title mb-3">What to Include</h4>
                        <ul class="guideline-list">
                            <li>Detailed timeline of events</li>
                            <li>IP addresses and domains involved</li>
                            <li>Email headers for phishing</li>
                            <li>Transaction details for fraud</li>
                        </ul>
                    </div>
                </div>

                <!-- Response Timeline -->
                <div class="col-lg-3 col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-icon mb-4">
                            <i class="bi bi-clock-fill"></i>
                        </div>
                        <h4 class="guideline-title mb-3">Response Timeline</h4>
                        <ul class="guideline-list timeline">
                            <li><strong class="emergency">Emergency:</strong> Response within 1 hour</li>
                            <li><strong class="high">High Priority:</strong> Response within 4 hours</li>
                            <li><strong class="medium">Medium Priority:</strong> Response within 24 hours</li>
                            <li><strong class="low">Low Priority:</strong> Response within 72 hours</li>
                        </ul>
                    </div>
                </div>

                <!-- Other Reporting Options -->
                <div class="col-lg-3 col-md-6">
                    <div class="guideline-card">
                        <div class="guideline-icon mb-4">
                            <i class="bi bi-telephone-fill"></i>
                        </div>
                        <h4 class="guideline-title mb-3">Other Reporting Options</h4>
                        <ul class="guideline-list">
                            <li>24/7 Emergency Hotline</li>
                            <li>Secure Email: report@bci.com</li>
                            <li>Encrypted Messaging Available</li>
                            <li>In-person reporting by appointment</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

 <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <!-- Report Cybercrime AJAX Handler -->
    <script src="js/report-cybercrime-ajax.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'report-cybercrime.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'report-cybercrime') ||
                    (currentPage === 'report-cybercrime.php' && linkPage === 'report-cybercrime')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
</body>
</html>